<?php
/**
 * Plugin Name: CentAudit Trail 
 * Description: Custom role-based audit trail plugin to track user logins, logouts, and site-wide activities.
 * Version: 1.0.0
 * Author: Cent avenue
 * Requires at least: 6.8.1
 * Requires PHP: PHP 8.2.12 and above
 */

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}

// Define constants
define('AT_PLUGIN_DIR', plugin_dir_path(__FILE__));
define('AT_PLUGIN_URL', plugin_dir_url(__FILE__));
define('AT_PLUGIN_VERSION', '1.0.0');

// Include required files
require_once AT_PLUGIN_DIR . 'includes/class-audit-logger.php';
require_once AT_PLUGIN_DIR . 'includes/class-audit-display.php';
require_once AT_PLUGIN_DIR . 'includes/class-audit-settings.php';
require_once AT_PLUGIN_DIR . 'includes/class-audit-export.php';
add_action('admin_enqueue_scripts', function () {
            wp_enqueue_style('audit-fontawesome', 'https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css');
            wp_enqueue_style('audit-trail-admin-style', plugin_dir_url(__FILE__) . 'css/audit-trail-admin.css');
        });
// Register Activation Hook
register_activation_hook(__FILE__, function () {
    Audit_Logger::create_tables();
    if (!wp_next_scheduled('at_delete_old_logs')) {
        wp_schedule_event(time(), 'daily', 'at_delete_old_logs');
    }
});

// Register Deactivation Hook
register_deactivation_hook(__FILE__, function () {
    wp_clear_scheduled_hook('at_delete_old_logs');
});

// Register Cron Action
add_action('at_delete_old_logs', 'at_delete_old_logs_handler');

function at_delete_old_logs_handler() {
    $days = get_option('at_log_retention_days', 30);
    Audit_Logger::delete_old_logs($days);
}

// Admin Menu
add_action('admin_menu', function () {
    add_menu_page('Audit Trail', 'Audit Trail', 'read', 'audit-trail', ['Audit_Display', 'render_main_page'], 'dashicons-shield-alt');
    add_submenu_page('audit-trail', 'Audit Settings', 'Settings', 'manage_options', 'audit-trail-settings', ['Audit_Settings', 'render_settings_page']);
});

// Plugin Init
add_action('init', function () {
    Audit_Logger::hook_events();
});

// Enqueue admin styles/scripts
add_action('admin_enqueue_scripts', function () {
    wp_enqueue_style('at-admin-style', AT_PLUGIN_URL . 'assets/css/admin.css', [], AT_PLUGIN_VERSION);
    wp_enqueue_script('at-admin-script', AT_PLUGIN_URL . 'assets/js/admin.js', ['jquery'], AT_PLUGIN_VERSION, true);
});
